<?php
require_once 'config/db.php';

$error = '';
$success = '';

// Check if admin already exists
$stmt = $pdo->query("SELECT COUNT(*) as count FROM users WHERE is_admin = 1");
$adminExists = $stmt->fetch()['count'] > 0;

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $name = trim($_POST['name'] ?? '');
    $mobile = trim($_POST['mobile'] ?? '');
    $password = $_POST['password'] ?? '';
    $confirm_password = $_POST['confirm_password'] ?? '';
    $secret_key = $_POST['secret_key'] ?? '';
    
    // Secret key for security (change this)
    $valid_secret = 'SATTAKING2024';
    
    if ($secret_key !== $valid_secret) {
        $error = 'Invalid secret key!';
    } elseif (empty($name) || empty($mobile) || empty($password)) {
        $error = 'All fields are required';
    } elseif (!preg_match('/^[0-9]{10}$/', $mobile)) {
        $error = 'Enter valid 10 digit mobile number';
    } elseif (strlen($password) < 6) {
        $error = 'Password must be at least 6 characters';
    } elseif ($password !== $confirm_password) {
        $error = 'Passwords do not match';
    } else {
        // Check if mobile already exists
        $stmt = $pdo->prepare("SELECT id FROM users WHERE mobile = ?");
        $stmt->execute([$mobile]);
        
        if ($stmt->fetch()) {
            $error = 'Mobile number already registered';
        } else {
            $hash = password_hash($password, PASSWORD_DEFAULT);
            $stmt = $pdo->prepare("INSERT INTO users (name, mobile, password, is_admin, status) VALUES (?, ?, ?, 1, 'active')");
            
            if ($stmt->execute([$name, $mobile, $hash])) {
                $success = 'Admin account created successfully! You can now login.';
            } else {
                $error = 'Something went wrong';
            }
        }
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Create Admin - Satta King</title>
    <link rel="stylesheet" href="assets/css/style.css">
</head>
<body>
    <div class="auth-container">
        <div class="auth-box">
            <h1>🔐 ADMIN SETUP</h1>
            
            <?php if ($error): ?>
                <div class="alert alert-error"><?= htmlspecialchars($error) ?></div>
            <?php endif; ?>
            
            <?php if ($success): ?>
                <div class="alert alert-success"><?= htmlspecialchars($success) ?></div>
                <a href="login.php" class="btn btn-gold" style="margin-top: 15px;">Go to Login</a>
            <?php else: ?>
                
                <?php if ($adminExists): ?>
                    <div class="alert" style="background: rgba(255,215,0,0.2); border: 1px solid var(--gold); color: var(--gold);">
                        ⚠️ Admin account already exists. You can create another admin if needed.
                    </div>
                <?php endif; ?>
                
                <form method="POST">
                    <div class="form-group">
                        <label>Secret Key</label>
                        <input type="password" name="secret_key" placeholder="Enter secret key" required>
                        <small style="color: var(--text-gray);">Default: SATTAKING2024</small>
                    </div>
                    
                    <div class="form-group">
                        <label>Admin Name</label>
                        <input type="text" name="name" placeholder="Enter admin name" required>
                    </div>
                    
                    <div class="form-group">
                        <label>Mobile Number</label>
                        <input type="tel" name="mobile" placeholder="10 digit mobile number" maxlength="10" required>
                    </div>
                    
                    <div class="form-group">
                        <label>Password</label>
                        <input type="password" name="password" placeholder="Create password" required>
                    </div>
                    
                    <div class="form-group">
                        <label>Confirm Password</label>
                        <input type="password" name="confirm_password" placeholder="Confirm password" required>
                    </div>
                    
                    <button type="submit" class="btn btn-gold">CREATE ADMIN</button>
                </form>
                
                <p class="auth-link" style="margin-top: 20px;">
                    <a href="login.php">← Back to Login</a>
                </p>
            <?php endif; ?>
        </div>
    </div>
</body>
</html>
