<?php
require_once 'config/db.php';
require_once 'config/auth.php';
require_once 'config/functions.php';
require_once 'config/security.php';

initSecureSession();
requireLogin();

if (!checkSessionTimeout($pdo)) {
    header("Location: login.php?msg=Session+expired");
    exit();
}

$user = getUser($pdo);
if (!$user) {
    session_destroy();
    header("Location: login.php");
    exit();
}

// Mark as read
if (isset($_GET['mark_read'])) {
    if ($_GET['mark_read'] == 'all') {
        markNotificationsRead($pdo, $user['id']);
    } else {
        markNotificationsRead($pdo, $user['id'], intval($_GET['mark_read']));
    }
    header("Location: notifications.php");
    exit();
}

// Get notifications
$notifications = getNotifications($pdo, $user['id'], 50);
$unreadCount = getUnreadNotificationCount($pdo, $user['id']);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Notifications - Satta King</title>
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body {
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
            background: #0f0f0f;
            color: #fff;
            min-height: 100vh;
            padding-bottom: 80px;
        }
        .header {
            background: linear-gradient(135deg, #8b0000 0%, #1a1a1a 100%);
            padding: 15px 20px;
            display: flex;
            justify-content: space-between;
            align-items: center;
            position: sticky;
            top: 0;
            z-index: 100;
        }
        .back-btn {
            color: #fff;
            text-decoration: none;
            font-size: 24px;
        }
        .header-title {
            font-size: 18px;
            font-weight: 600;
        }
        .mark-all {
            color: #ffd700;
            text-decoration: none;
            font-size: 13px;
        }
        .container {
            padding: 15px;
            max-width: 600px;
            margin: 0 auto;
        }
        .notification-item {
            background: #1a1a1a;
            border-radius: 12px;
            padding: 15px;
            margin-bottom: 10px;
            border-left: 4px solid #333;
            transition: all 0.3s;
        }
        .notification-item.unread {
            border-left-color: #ffd700;
            background: #1a1a2e;
        }
        .notification-header {
            display: flex;
            justify-content: space-between;
            align-items: flex-start;
            margin-bottom: 8px;
        }
        .notification-title {
            font-weight: 600;
            color: #ffd700;
            font-size: 14px;
        }
        .notification-time {
            font-size: 11px;
            color: #888;
        }
        .notification-message {
            font-size: 13px;
            color: #ccc;
            line-height: 1.5;
        }
        .notification-icon {
            font-size: 24px;
            margin-right: 12px;
        }
        .notification-content {
            flex: 1;
        }
        .notification-body {
            display: flex;
            align-items: flex-start;
        }
        .empty-state {
            text-align: center;
            padding: 60px 20px;
            color: #888;
        }
        .empty-icon {
            font-size: 60px;
            margin-bottom: 15px;
        }
        .unread-badge {
            background: #ff4444;
            color: white;
            padding: 2px 8px;
            border-radius: 10px;
            font-size: 11px;
            margin-left: 10px;
        }
        /* Bottom Navigation */
        .bottom-nav {
            position: fixed;
            bottom: 0;
            left: 0;
            right: 0;
            background: #1a1a1a;
            display: flex;
            justify-content: space-around;
            padding: 10px 0;
            border-top: 1px solid #333;
        }
        .nav-item {
            text-decoration: none;
            color: #888;
            text-align: center;
            font-size: 12px;
        }
        .nav-item.active { color: #ffd700; }
        .nav-icon { font-size: 20px; display: block; margin-bottom: 2px; }
    </style>
</head>
<body>
    <div class="header">
        <a href="index.php" class="back-btn">←</a>
        <span class="header-title">🔔 Notifications <?php if ($unreadCount > 0): ?><span class="unread-badge"><?= $unreadCount ?></span><?php endif; ?></span>
        <?php if ($unreadCount > 0): ?>
            <a href="?mark_read=all" class="mark-all">Mark all read</a>
        <?php else: ?>
            <span></span>
        <?php endif; ?>
    </div>
    
    <div class="container">
        <?php if (empty($notifications)): ?>
            <div class="empty-state">
                <div class="empty-icon">🔔</div>
                <p>No notifications yet</p>
            </div>
        <?php else: ?>
            <?php foreach ($notifications as $notif): 
                $icon = '🔔';
                switch ($notif['type']) {
                    case 'win': $icon = '🏆'; break;
                    case 'deposit_approved': $icon = '💰'; break;
                    case 'withdraw_approved': $icon = '💸'; break;
                    case 'bid_placed': $icon = '🎰'; break;
                    case 'bid_cancelled': $icon = '↩️'; break;
                    case 'referral_bonus': $icon = '🎁'; break;
                    case 'welcome': $icon = '👋'; break;
                    case 'welcome_bonus': $icon = '🎁'; break;
                    case 'result': $icon = '📊'; break;
                }
            ?>
            <div class="notification-item <?= $notif['is_read'] ? '' : 'unread' ?>">
                <div class="notification-body">
                    <span class="notification-icon"><?= $icon ?></span>
                    <div class="notification-content">
                        <div class="notification-header">
                            <span class="notification-title"><?= htmlspecialchars($notif['title']) ?></span>
                            <span class="notification-time"><?= date('d M, h:i A', strtotime($notif['created_at'])) ?></span>
                        </div>
                        <div class="notification-message"><?= htmlspecialchars($notif['message']) ?></div>
                    </div>
                </div>
            </div>
            <?php endforeach; ?>
        <?php endif; ?>
    </div>
    
    <!-- Bottom Navigation -->
    <nav class="bottom-nav">
        <a href="index.php" class="nav-item">
            <span class="nav-icon">🏠</span>
            Home
        </a>
        <a href="wallet.php" class="nav-item">
            <span class="nav-icon">💰</span>
            Wallet
        </a>
        <a href="history.php" class="nav-item">
            <span class="nav-icon">📜</span>
            History
        </a>
        <a href="notifications.php" class="nav-item active">
            <span class="nav-icon">🔔</span>
            Alerts
        </a>
        <a href="profile.php" class="nav-item">
            <span class="nav-icon">👤</span>
            Profile
        </a>
    </nav>
</body>
</html>
