<?php
// Debug Mode - Set to false in production
define('DEBUG_MODE', true);

if (DEBUG_MODE) {
    error_reporting(E_ALL);
    ini_set('display_errors', 1);
    ini_set('display_startup_errors', 1);
} else {
    error_reporting(0);
    ini_set('display_errors', 0);
}

// Custom error handler
function customErrorHandler($errno, $errstr, $errfile, $errline) {
    if (!DEBUG_MODE) return false;
    
    $errorTypes = [
        E_ERROR => 'Error',
        E_WARNING => 'Warning',
        E_PARSE => 'Parse Error',
        E_NOTICE => 'Notice',
        E_CORE_ERROR => 'Core Error',
        E_CORE_WARNING => 'Core Warning',
        E_COMPILE_ERROR => 'Compile Error',
        E_COMPILE_WARNING => 'Compile Warning',
        E_USER_ERROR => 'User Error',
        E_USER_WARNING => 'User Warning',
        E_USER_NOTICE => 'User Notice',
        E_STRICT => 'Strict',
        E_RECOVERABLE_ERROR => 'Recoverable Error',
        E_DEPRECATED => 'Deprecated',
        E_USER_DEPRECATED => 'User Deprecated',
    ];
    
    $type = $errorTypes[$errno] ?? 'Unknown Error';
    
    echo "<div style='background:#ff000020; border:1px solid #ff0000; color:#ff6666; padding:15px; margin:10px; border-radius:8px; font-family:monospace;'>";
    echo "<strong>🔴 $type:</strong> $errstr<br>";
    echo "<strong>File:</strong> $errfile<br>";
    echo "<strong>Line:</strong> $errline";
    echo "</div>";
    
    return true;
}

// Custom exception handler
function customExceptionHandler($exception) {
    if (!DEBUG_MODE) return;
    
    echo "<div style='background:#ff000020; border:1px solid #ff0000; color:#ff6666; padding:15px; margin:10px; border-radius:8px; font-family:monospace;'>";
    echo "<strong>🔴 Exception:</strong> " . $exception->getMessage() . "<br>";
    echo "<strong>File:</strong> " . $exception->getFile() . "<br>";
    echo "<strong>Line:</strong> " . $exception->getLine() . "<br>";
    echo "<strong>Trace:</strong><pre>" . $exception->getTraceAsString() . "</pre>";
    echo "</div>";
}

// Set handlers
set_error_handler('customErrorHandler');
set_exception_handler('customExceptionHandler');

// Debug log function
function debug_log($message, $data = null) {
    if (!DEBUG_MODE) return;
    
    echo "<div style='background:#ffd70020; border:1px solid #ffd700; color:#ffd700; padding:10px; margin:10px; border-radius:8px; font-family:monospace;'>";
    echo "<strong>🔍 Debug:</strong> $message";
    if ($data !== null) {
        echo "<pre>" . print_r($data, true) . "</pre>";
    }
    echo "</div>";
}

// Success log function
function debug_success($message) {
    if (!DEBUG_MODE) return;
    
    echo "<div style='background:#00ff0020; border:1px solid #00ff00; color:#00ff88; padding:10px; margin:10px; border-radius:8px; font-family:monospace;'>";
    echo "<strong>✅ Success:</strong> $message";
    echo "</div>";
}
?>